# 2023-07-18 Triage Log

A lot of spurious results in the regressions this week. However, we did see some
real gains with PR #113609, with nearly 40 real-world benchmarks improving their
check-build performance by >=1%.

Triage done by **@pnkfelix**.
Revision range: [1d4f5aff..6b9236ed](https://perf.rust-lang.org/?start=1d4f5affbdee00c816f961c227c6b28a3e725ce6&end=6b9236ed5a58879969ddcf4c35a6a24f6260e979&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.5%  | [0.6%, 3.0%]   | 11    |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.6%, 1.8%]   | 11    |
| Improvements ✅ <br /> (primary)   | -1.6% | [-3.7%, -0.6%] | 46    |
| Improvements ✅ <br /> (secondary) | -1.9% | [-4.2%, -0.4%] | 46    |
| All ❌✅ (primary)                 | -1.0% | [-3.7%, 3.0%]  | 57    |


5 Regressions, 5 Improvements, 5 Mixed; 2 of them in rollups
57 artifact comparisons made in total

#### Regressions

miri: protect Move() function arguments during the call [#113569](https://github.com/rust-lang/rust/pull/113569) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=910be1b3e83d8876a144441695b7a5077967296e&end=136dab66142115d9de16b4cfe2d8395d71a8ab6d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.5%, 1.1%] | 13    |
| Regressions ❌ <br /> (secondary)  | 0.9% | [0.4%, 1.4%] | 11    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.5%, 1.1%] | 13    |

* RalfJ is investigating; has potential fix up in [PR #113630](https://github.com/rust-lang/rust/pull/113630), ...
* ... but its not totally certain that PR is a real fix (i.e. the regression may already have been masked or otherwise resolved independently).
* But meanwhile, I am hypothesizing that the regression reported here is spurious ([discussion](https://rust-lang.zulipchat.com/#narrow/stream/247081-t-compiler.2Fperformance/topic/perf.20triage.202023-07-18/near/376402031))
* marking as triaged

Ignore flaky clippy tests. [#113621](https://github.com/rust-lang/rust/pull/113621) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1e6db3486da0f6474920477c01fca90453b7c428&end=33a2c2487ac5d9927830ea4c1844335c6b9f77db&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0% | [0.6%, 1.2%] | 7     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.0% | [0.6%, 1.2%] | 7     |

* already marked as triaged (its noise)

Rollup of 6 pull requests [#113673](https://github.com/rust-lang/rust/pull/113673) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a161ab00dbf660dd587ee42a8c855bac94047ddb&end=7bd81ee1902c049691d0a1f03be5558bee51d100&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2% | [1.2%, 1.2%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.2% | [1.2%, 1.2%] | 1     |

* addressed by PR #113697, already marked as triaged.

Add even more GHA log groups [#113514](https://github.com/rust-lang/rust/pull/113514) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ad963232d9b987d66a6f8e6ec4141f672b8b9900&end=4d6e4260b2de66a356a2536320f339467dff0d2b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 2.9% | [2.7%, 3.0%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

* PR author says "this doesn't affect how the compiler was built at all, the perf regression must be spurious."
* I agree, marking as triaged

Rollup of 3 pull requests [#113738](https://github.com/rust-lang/rust/pull/113738) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4124617c6ebe6b5b4df2c8c8400e87389c377dcc&end=2c718d12599ca00dc3957ec604cb3e87fe437124&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.7%, 0.7%] | 1     |
| Regressions ❌ <br /> (secondary)  | 3.1% | [2.7%, 3.5%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.7%, 0.7%] | 1     |


#### Improvements

Rewrite `UnDerefer`, again [#113316](https://github.com/rust-lang/rust/pull/113316) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fcaf04e715bf74ddcbba4c6b0f9adfa00bae1af6&end=5b733e2bcaf784e6a8c523a6d5e74d7263ec7915&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [1.2%, 1.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.7%, -0.4%] | 14    |
| Improvements ✅ <br /> (secondary) | -1.2% | [-2.0%, -0.2%] | 21    |
| All ❌✅ (primary)                 | -0.8% | [-1.7%, 1.2%]  | 15    |


(re-)tighten sourceinfo span of adjustments in MIR [#112945](https://github.com/rust-lang/rust/pull/112945) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=136dab66142115d9de16b4cfe2d8395d71a8ab6d&end=da1d099f91ea387a2814a6244dd875a2048b486f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.1%, -0.4%] | 18    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.5%] | 5     |
| All ❌✅ (primary)                 | -0.7% | [-1.1%, -0.4%] | 18    |


Bump bootstrap to 1.72 beta [#113637](https://github.com/rust-lang/rust/pull/113637) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1b3e68692592d71938df8e7fd8e53fbe5e7ef58c&end=a161ab00dbf660dd587ee42a8c855bac94047ddb&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.2%, -0.6%] | 12    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.9% | [-1.2%, -0.6%] | 12    |


Add a cache for `maybe_lint_level_root_bounded` [#113609](https://github.com/rust-lang/rust/pull/113609) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7d60819bfd0d66bdc300713101bd285350407038&end=fe03b46ee4688a99d7155b4f9dcd875b6903952d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.4% | [-3.4%, -0.5%] | 29    |
| Improvements ✅ <br /> (secondary) | -1.9% | [-5.9%, -0.2%] | 33    |
| All ❌✅ (primary)                 | -1.4% | [-3.4%, -0.5%] | 29    |


Remove `LLVMRustCoverageHashCString` [#113430](https://github.com/rust-lang/rust/pull/113430) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2c718d12599ca00dc3957ec604cb3e87fe437124&end=ffb9b61294b96c389d343a4c55b15400249d74e6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.7%, -0.7%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.8% | [-3.2%, -2.4%] | 6     |
| All ❌✅ (primary)                 | -0.7% | [-0.7%, -0.7%] | 2     |


#### Mixed

Eliminate ZST allocations in `Box` and `Vec` [#113113](https://github.com/rust-lang/rust/pull/113113) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7a5814f922f85370e773f2001886b8f57002811c&end=cca3373706b8f5fa12a1b7f18222dde4c3ed6e32&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.7%  | [0.5%, 3.5%]   | 3     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.7%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.6%  | [-1.7%, 3.5%]  | 5     |

* regressions here were anticipated and unavoidable. This is a bug fix.
* Marking as triaged.


Enable MIR reference propagation by default [#109025](https://github.com/rust-lang/rust/pull/109025) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5767cad9b8b58a5c0521c5ddd652a24d0c65f466&end=079e544174b79c372b4b4b473a01d699f128c2de&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [0.5%, 2.5%]   | 15    |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.2%, 1.3%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.0%, -0.8%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.1%, -0.4%] | 6     |
| All ❌✅ (primary)                 | 0.8%  | [-1.0%, 2.5%]  | 18    |

* This is turning on a MIR pass at lower optimizations levels, so its expected that it would cause the compiler to do more work.
* its clear from the perf runs on the PR itself that the PR author already put in much effort to make the pass faster than it had started out.
* marking as triaged.

Resurrect: rustc_target: Add alignment to indirectly-passed by-value types, correcting the alignment of byval on x86 in the process. [#112157](https://github.com/rust-lang/rust/pull/112157) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4d6e4260b2de66a356a2536320f339467dff0d2b&end=7a17f577b3d437179cad254e299b2ace972487c5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.7%  | [1.5%, 2.0%]   | 6     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.8% | [-2.9%, -2.8%] | 6     |
| All ❌✅ (primary)                 | 1.7%  | [1.5%, 2.0%]   | 6     |

* The six primary regressions were all to variants of diesel (all of check/debug/opt) for variious full and incr-full scenarios.
* It isn't noise, there seems to be a clear cliff that starts with this PR when looking at the graph starting from 2023-0702.
* not marking as triaged yet, but was tempted to do so, because this PR is a prerequiste for unlocking various memcpy optimizations added by pcwalton to LLVM

Remove unneeded handling for `ExternalLocation::Unknown` in rustdoc render context [#113697](https://github.com/rust-lang/rust/pull/113697) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=425726d46b637f94995ca1c95f4f16cdb903d30e&end=4c8bb79d9f565115637cc6da739f8389e79f3a29&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 3.0%  | [2.5%, 3.4%]   | 6     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.1%, -1.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.1% | [-1.1%, -1.1%] | 1     |

* this was mentioned up above when I was talking about PR #113673
* the secondary regressions are all to ctfe-stress-5, which lqd says was noisy at this time.
* marked as triaged.

Add support for allocators in `Rc` & `Arc` [#89132](https://github.com/rust-lang/rust/pull/89132) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1787f312907eee9a4a9ac010985d725ad9a03ab6&end=da6b55cc5eaf76ed6acb7dc2f7d611e32af7c9a7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.8%, 0.8%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-1.3%, -1.3%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.8%, -0.5%] | 4     |
| All ❌✅ (primary)                 | -0.3% | [-1.3%, 0.8%]  | 2     |

Visiting for perf-triage

* primary regression was to image-0.24.1 opt full by 0.79%
* I think this is just noise. From the [graph](https://perf.rust-lang.org/index.html?start=2023-06-17&end=2023-07-18&benchmark=image-0.24.1&profile=opt&scenario=full&stat=instructions%3Au&kind=raw), it seems like image has unpredictably jumped up and down between two plateaus since PR #113113 (a PR discussed up above that changed low level allocation procotol code in Box and Vec, and thus might be expected to have some weird follow-on effects).
* marked as triaged

#### Untriaged Pull Requests

- [#113738 Rollup of 3 pull requests](https://github.com/rust-lang/rust/pull/113738)
- [#113697 Remove unneeded handling for `ExternalLocation::Unknown` in rustdoc render context](https://github.com/rust-lang/rust/pull/113697)
- [#113569 miri: protect Move() function arguments during the call](https://github.com/rust-lang/rust/pull/113569)
- [#113514 Add even more GHA log groups](https://github.com/rust-lang/rust/pull/113514)
- [#113485 Bump version to 1.73](https://github.com/rust-lang/rust/pull/113485)
- [#113370 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/113370)
- [#113320 Add some extra information to opaque type cycle errors](https://github.com/rust-lang/rust/pull/113320)
- [#113306 Update debuginfo test runner to provide more useful output](https://github.com/rust-lang/rust/pull/113306)
- [#113304 Upgrade to indexmap 2.0.0](https://github.com/rust-lang/rust/pull/113304)
- [#113270 perform TokenStream replacement in-place when possible in expand_macro](https://github.com/rust-lang/rust/pull/113270)
- [#113113 Eliminate ZST allocations in `Box` and `Vec`](https://github.com/rust-lang/rust/pull/113113)
- [#113057 Rollup of 2 pull requests](https://github.com/rust-lang/rust/pull/113057)
- [#112963 Stop bubbling out hidden types from the eval obligation queries](https://github.com/rust-lang/rust/pull/112963)
- [#112882 Rewrite `UnDerefer`](https://github.com/rust-lang/rust/pull/112882)
- [#112420 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/112420)
- [#112157 Resurrect: rustc_target: Add alignment to indirectly-passed by-value types, correcting the alignment of byval on x86 in the process.](https://github.com/rust-lang/rust/pull/112157)
- [#112083 Make `TrustedStep` require `Copy`](https://github.com/rust-lang/rust/pull/112083)
- [#112016 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/112016)
- [#112001 Enable MatchBranchSimplification](https://github.com/rust-lang/rust/pull/112001)
- [#111869 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/111869)
- [#111850 Specialize `StepBy<Range<{integer}>>`](https://github.com/rust-lang/rust/pull/111850)
- [#111813 MIR: opt-in normalization of `BasicBlock` and `Local` numbering](https://github.com/rust-lang/rust/pull/111813)
- [#111623 move `super_relate_consts` hack to `normalize_param_env_or_error`](https://github.com/rust-lang/rust/pull/111623)
- [#111524 `ascii::Char`-ify the escaping code in `core`](https://github.com/rust-lang/rust/pull/111524)
- [#111425 Populate effective visibilities in `rustc_privacy` (take 2)](https://github.com/rust-lang/rust/pull/111425)
- [#111364 Remove the ThinLTO CU hack](https://github.com/rust-lang/rust/pull/111364)
- [#111311 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/111311)
- [#111306 Update hashbrown from 0.12.3 to 0.13.1 for std](https://github.com/rust-lang/rust/pull/111306)
- [#111221 Combine three generalizer implementations](https://github.com/rust-lang/rust/pull/111221)
- [#111007 Disable nrvo mir opt](https://github.com/rust-lang/rust/pull/111007)

#### Nags requiring follow up

TODO: Nags

