# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.settings import settings
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from ._configuration import HardwareSecurityModulesMgmtClientConfiguration
from ._utils.serialization import Deserializer, Serializer
from .operations import (
    CloudHsmClusterBackupStatusOperations,
    CloudHsmClusterPrivateEndpointConnectionsOperations,
    CloudHsmClusterPrivateLinkResourcesOperations,
    CloudHsmClusterRestoreStatusOperations,
    CloudHsmClustersOperations,
    DedicatedHsmOperations,
    Operations,
    PrivateEndpointConnectionsOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials import TokenCredential


class HardwareSecurityModulesMgmtClient:  # pylint: disable=too-many-instance-attributes
    """The Azure management API provides a RESTful set of web services that interact with Hardware
    Security Modules.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.hardwaresecuritymodules.operations.Operations
    :ivar cloud_hsm_clusters: CloudHsmClustersOperations operations
    :vartype cloud_hsm_clusters:
     azure.mgmt.hardwaresecuritymodules.operations.CloudHsmClustersOperations
    :ivar private_endpoint_connections: PrivateEndpointConnectionsOperations operations
    :vartype private_endpoint_connections:
     azure.mgmt.hardwaresecuritymodules.operations.PrivateEndpointConnectionsOperations
    :ivar cloud_hsm_cluster_private_link_resources: CloudHsmClusterPrivateLinkResourcesOperations
     operations
    :vartype cloud_hsm_cluster_private_link_resources:
     azure.mgmt.hardwaresecuritymodules.operations.CloudHsmClusterPrivateLinkResourcesOperations
    :ivar cloud_hsm_cluster_backup_status: CloudHsmClusterBackupStatusOperations operations
    :vartype cloud_hsm_cluster_backup_status:
     azure.mgmt.hardwaresecuritymodules.operations.CloudHsmClusterBackupStatusOperations
    :ivar cloud_hsm_cluster_restore_status: CloudHsmClusterRestoreStatusOperations operations
    :vartype cloud_hsm_cluster_restore_status:
     azure.mgmt.hardwaresecuritymodules.operations.CloudHsmClusterRestoreStatusOperations
    :ivar cloud_hsm_cluster_private_endpoint_connections:
     CloudHsmClusterPrivateEndpointConnectionsOperations operations
    :vartype cloud_hsm_cluster_private_endpoint_connections:
     azure.mgmt.hardwaresecuritymodules.operations.CloudHsmClusterPrivateEndpointConnectionsOperations
    :ivar dedicated_hsm: DedicatedHsmOperations operations
    :vartype dedicated_hsm: azure.mgmt.hardwaresecuritymodules.operations.DedicatedHsmOperations
    :param credential: Credential used to authenticate requests to the service. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service host. Default value is None.
    :type base_url: str
    :keyword api_version: The API version to use for this operation. Default value is "2025-03-31".
     Note that overriding this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "TokenCredential", subscription_id: str, base_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        _endpoint = "{endpoint}"
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = HardwareSecurityModulesMgmtClientConfiguration(
            credential=credential,
            subscription_id=subscription_id,
            base_url=cast(str, base_url),
            credential_scopes=credential_scopes,
            **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=cast(str, _endpoint), policies=_policies, **kwargs)

        self._serialize = Serializer()
        self._deserialize = Deserializer()
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.cloud_hsm_clusters = CloudHsmClustersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cloud_hsm_cluster_private_link_resources = CloudHsmClusterPrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cloud_hsm_cluster_backup_status = CloudHsmClusterBackupStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cloud_hsm_cluster_restore_status = CloudHsmClusterRestoreStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cloud_hsm_cluster_private_endpoint_connections = CloudHsmClusterPrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dedicated_hsm = DedicatedHsmOperations(self._client, self._config, self._serialize, self._deserialize)

    def send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client.send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        request_copy.url = self._client.format_url(request_copy.url, **path_format_arguments)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
