// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package filesystem

import (
	"encoding/json"
	"fmt"
	"os"
)

func loadJSON(filename string, data any) {
	bs, err := os.ReadFile(filename)
	if err != nil {
		panic(fmt.Errorf("ReadFile %w", err))
	}

	if err := json.Unmarshal(bs, data); err != nil {
		panic(fmt.Errorf("Unmarshal %s %s %w", filename, string(bs), err))
	}
}

func saveJSON(filename string, data any) {
	f, err := os.Create(filename)
	if err != nil {
		panic(fmt.Errorf("Create %w", err))
	}
	defer f.Close()
	bs, err := json.MarshalIndent(data, "", "    ")
	if err != nil {
		panic(fmt.Errorf("MarshalIndent %w", err))
	}
	if _, err := f.Write(bs); err != nil {
		panic(fmt.Errorf("Write %w", err))
	}
}
